using System;
using Server;
using Server.Items;
using Server.Mobiles;
using System.Collections;

namespace Server.Guilds
{
    public class GuildCoinsRewards
    {
        public int Cost;       // cost of the reward in credits
        public Type  RewardType;   // this will be used to create an instance of the reward
        public string Name;         // used to describe the reward in the gump
        public object [] RewardArgs; // arguments passed to the reward constructor
        public RankDefinition Rank;   // ((PlayerMobile)m_Leader).GuildRank = RankDefinition.Member; 

        private static ArrayList    PointsRewardList = new ArrayList();
        
        public static ArrayList RewardsList { get { return PointsRewardList; } }
        
        public GuildCoinsRewards(RankDefinition rank, Type reward, string name, int cost, object[] args)
        {
            RewardType = reward;
            Cost = cost;
            Name = name;
            RewardArgs = args;
            Rank = rank;
        }
        
        public static void Initialize()
        {
            // these are items as rewards. Note that the args list must match a constructor for the reward type specified.
            // this is an example of adding a mobile as a reward
//             PointsRewardList.Add( new GuildCoinsRewards( 0, typeof(RidableLlama),"Ridable Llama", 1, 0x20f6, null));

//             PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BannerDeed), "Banner (Vlajka) (deed - ruzne vzhledy, obarvitelne)", 100000, new object[] { 1 }));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(DyeThinner), "Redidlo na barvy (5 kusu)", 100000, new object[] { 5 }));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(DyeRackDeed), "Stojan na barvy (deed)", 150000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BannerDeed), "Banner (Vlajka) (deed - ruzne vzhledy, obarvitelne)", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(ElvenDisplayCaseDeed), "Elven display case (deed - denne evolution dusty)", 150000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BloodyPentagramDeed), "Krvavy pentagram - deed", 300000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(GuillotineDeed), "Guillotine (deed - nebezpecny popravci nastroj)", 150000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(HangingSkeletonDeed), "Hanging skeleton - visici kostra (deed - ruzne vzhledy)", 50000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(IronMaidenDeed), "Iron Maiden - Zelezna panna (deed - mucici nastroj)", 150000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(MiningCartDeed), "Mining Cart - Hornicky vozik (deed - denne ingoty nebo drahokamy)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(MinotaurStatueDeed), "Minotaur statue - Socha minotaura (deed - ruzne vzhledy)", 500000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(StoneStatueDeed), "Statue - Velka socha (deed - oba smery)", 500000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(TableWithBlueClothDeed), "Stul s modrym ubrusem - deed", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(TableWithOrangeClothDeed), "Stul s oranzovym ubrusem - deed", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(TableWithPurpleClothDeed), "Stul s fialovym ubrusem - deed", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(TableWithRedClothDeed), "Stul s cervenym ubrusem - deed", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(UnmadeBedDeed), "Unmade bed - Neustlana postel (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(WallBannerDeed), "Wall Banner - Nastenne vlajky (deed - ruzne vzhledy, obarvitelne)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(WallTorchDeed), "Wall torch - Nastenna louc (deed - oba smery, zapalitelne)", 25000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(WoodenCoffinDeed), "Wooden coffin - Drevena rakev (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenArmoireDeed), "Broken armoire (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenBedDeed), "Broken bed (deed - oba smery)", 200000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenBookcaseDeed), "Broken bookcase (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenCoveredChairDeed), "Broken covered chair (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenFallenChairDeed), "Broken fallen chair (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenChestOfDrawersDeed), "Broken chest of drawers (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(BrokenVanityDeed), "Broken vanity (deed - oba smery)", 100000, null));
            PointsRewardList.Add( new GuildCoinsRewards( RankDefinition.Leader, typeof(StandingBrokenChairDeed), "Broken standing chair (deed - oba smery)", 100000, null));
        }

    }
}
